/*----------------------------------------------------------
 function [data.F, data.Diva, data.Divb, data.Divc] = ...
    ComputeDiffCommonDiscreteS2(p,hx,hy, u, v, w)
----------------------------------------------------------*/

#include "mex.h"

/* The gateway routine */
void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{
  /* Input */  
  double *u, *v, *w;
  double p, hx, hy;
  int mrows,ncols;
  
  /* Output */  
  double *F, *Diva, *Divb, *Divc;
  
  double zeta_x_sq, zeta_y_sq,Fp2;
  double  *f1x, *f2x, *f3x, *f1y, *f2y, *f3y;
  double uval, uval1, vval, vval1, wval, wval1;
  double meanu, diffu, meanv, diffv, meanw, diffw;
  int di, dj, idi, idj;
  
  
  /*  Check for proper number of arguments. */
  /* NOTE: You do not need an else statement when using 
     mexErrMsgTxt within an if statement. It will never 
     get to the else statement if mexErrMsgTxt is executed. 
     (mexErrMsgTxt breaks you out of the MEX-file.) 
  */ 
  if (nrhs != 6) 
    mexErrMsgTxt("Six inputs required.");
  if (nlhs != 4) 
    mexErrMsgTxt("Four output required.");
  
  /* Check to make sure the first input argument is a scalar. */
  if (!mxIsDouble(prhs[0]) || mxIsComplex(prhs[0]) ||
      mxGetN(prhs[0])*mxGetM(prhs[0]) != 1) {
    mexErrMsgTxt("Input x must be a scalar.");
  }
  
  /* Get the scalar input p, hx, hy. */
  p     = mxGetScalar(prhs[0]);
  hx    = mxGetScalar(prhs[1]);
  hy    = mxGetScalar(prhs[2]);
  
  /* Create a pointer to the input matrix u, v, w. */
  u = mxGetPr(prhs[3]);
  v = mxGetPr(prhs[4]);
  w = mxGetPr(prhs[5]);
  
  /* Get the dimensions of the matrix input y. */
  mrows = mxGetM(prhs[3]);
  ncols = mxGetN(prhs[3]);
  
  /* Set the output pointer to the output matrix F */
  plhs[0] = mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL);
  
  /* Create a C pointer to a copy of the output matrix F */
  F     = mxGetPr(plhs[0]);
  
  /* Create  */
  
  /*
  zeta_x_sq = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));
  zeta_y_sq = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));
  Fp2 = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));
  */
   
  f1x = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));
  f2x = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));
  f3x = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));

  f1y = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));
  f2y = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));
  f3y = mxGetPr(mxCreateDoubleMatrix(mrows-1,ncols-1, mxREAL));  
  
  for( di = 1; di<mrows; di++ )
  {
    for( dj = 1; dj<ncols; dj++ )
    {
        /* x direction */
        idi = dj*mrows + di;    idj = idi-1;
        uval = u[idi];   uval1 = u[idj];
        vval = v[idi];   vval1 = v[idj];
        wval = w[idi];   wval1 = w[idj];
       
        /* f1 is of order (m-1, n-1), store at (di-1, dj-1) */
        idi = (dj-1)*(mrows -1) + di-1;   
        
	zeta_x_sq = 0.25*( (uval+uval1)*(uval+uval1) + 
                                (vval+vval1)*(vval+vval1) +
                                (wval+wval1)*(wval+wval1) );

        f1x[idi] = ( uval1*vval - uval*vval1 ) /  zeta_x_sq;
        f2x[idi] = ( uval1*wval - uval*wval1 ) /  zeta_x_sq;
        f3x[idi] = ( vval1*wval - vval*wval1 ) /  zeta_x_sq;

	/*
	meanu = 0.5*(uval + uval1); 	diffu = uval - uval1;
	meanv = 0.5*(vval + vval1); 	diffv = vval - vval1;
	meanw = 0.5*(wval + wval1); 	diffw = wval - wval1;

        zeta_x_sq = meanu*meanu + meanv*meanv + meanw*meanw; 

        f1x[idi] = ( meanu*diffv - meanv*diffu ) /  zeta_x_sq;
        f2x[idi] = ( meanu*diffw - meanw*diffu ) /  zeta_x_sq;
        f3x[idi] = ( meanv*diffw - meanw*diffv ) /  zeta_x_sq;
        */
	
	Fp2 = f1x[idi]*f1x[idi] + f2x[idi]*f2x[idi] + f3x[idi]*f3x[idi];


        /* y direction */
        idj = (dj-1)*mrows + di;
        uval1 = u[idj];
        vval1 = v[idj];
        wval1 = w[idj];
        
        /* f1 is of order (m-1, n-1), store at (di-1, dj-1) */
	idi = (dj-1)*(mrows-1) + di-1;   

        zeta_y_sq = 0.25*( (uval+uval1)*(uval+uval1) + 
                                (vval+vval1)*(vval+vval1) +
                                (wval+wval1)*(wval+wval1) );

        f1y[idi] = ( uval1*vval - uval*vval1 ) /  zeta_y_sq;
        f2y[idi] = ( uval1*wval - uval*wval1 ) /  zeta_y_sq;
        f3y[idi] = ( vval1*wval - vval*wval1 ) /  zeta_y_sq;        
  

	/*
	meanu = 0.5*(uval + uval1); 	diffu = uval - uval1;
	meanv = 0.5*(vval + vval1); 	diffv = vval - vval1;
	meanw = 0.5*(wval + wval1); 	diffw = wval - wval1;

        zeta_y_sq = meanu*meanu + meanv*meanv + meanw*meanw; 

        f1y[idi] = ( meanu*diffv - meanv*diffu ) /  zeta_y_sq;
        f2y[idi] = ( meanu*diffw - meanw*diffu ) /  zeta_y_sq;
        f3y[idi] = ( meanv*diffw - meanw*diffv ) /  zeta_y_sq;
	*/
	
        Fp2 += (  f1y[idi]*f1y[idi] + f2y[idi]*f2y[idi]
			+ f3y[idi]*f3y[idi] );
   
        if ( p != 2 )
        {
	    /*
            if ( (int)p%2 != 0 || p-(int)p/2 )
            {
                Fp2 = Fp2 + 1e-6;
            }
	    */
           
	    Fp2 = Fp2 + 1e-6;
	    F[idi] = pow( Fp2, p/2);
                        
            /* then update F to F.^((p-2)/p) */
            Fp2 = F[idi]/ Fp2; 
            
        }
        else
        {
            F[idi] = Fp2;
            Fp2 = 1.0;
        }
        
        f1x[idi] = p*Fp2*f1x[idi] /  zeta_x_sq;
        f2x[idi] = p*Fp2*f2x[idi] /  zeta_x_sq;
        f3x[idi] = p*Fp2*f3x[idi] /  zeta_x_sq;
        
        f1y[idi] = p*Fp2*f1y[idi] /  zeta_y_sq;
        f2y[idi] = p*Fp2*f2y[idi] /  zeta_y_sq;
        f3y[idi] = p*Fp2*f3y[idi] /  zeta_y_sq;
        
    }
  }
  
  /* Set the output pointer to the output matrix Diva, Divb, Divc */
  plhs[1] = mxCreateDoubleMatrix(mrows-2,ncols-2, mxREAL);
  plhs[2] = mxCreateDoubleMatrix(mrows-2,ncols-2, mxREAL);
  plhs[3] = mxCreateDoubleMatrix(mrows-2,ncols-2, mxREAL);

  Diva  = mxGetPr(plhs[1]);
  Divb  = mxGetPr(plhs[2]);
  Divc  = mxGetPr(plhs[3]);
  


  for( di = 0; di<mrows-2; di++ )
  {
    for( dj = 0; dj<ncols-2; dj++ )
    {
        /* x direction */
        idi = (dj)*(mrows-1) + di;    idj = idi+1;
        uval = f1x[idi];   uval1 = f1x[idj];
	vval = f2x[idi];   vval1 = f2x[idj];
	wval = f3x[idi];   wval1 = f3x[idj];
	idi = (dj)*(mrows-2) + di; 
	Diva[idi] =  uval1 - uval;
	Divb[idi] = -vval1 + vval;
	Divc[idi] =  wval1 - wval;
	
	/* y direction */
        idi = (dj)*(mrows-1) + di;    idj = (dj+1)*(mrows-1) + di; 
        uval = f1y[idi];   uval1 = f1y[idj];
	vval = f2y[idi];   vval1 = f2y[idj];
	wval = f3y[idi];   wval1 = f3y[idj];
	idi = (dj)*(mrows-2) + di; 
	Diva[idi] += ( uval1 - uval);
	Divb[idi] += (-vval1 + vval);
	Divc[idi] += ( wval1 - wval);
    }
  }


  
}

