function data = CrossProductS2Harmonic(data)

% cross product
% Let    a = a1i + a2j + a3k = (a1, a2, a3)
%        b = b1i + b2j + b3k = (b1, b2, b3)
% Then
%     a  b = (a2b3 - a3b2) i + (a3b1 - a1b3) j + (a1b2 - a2b1) k
%           = (a2b3 - a3b2, a3b1 - a1b3, a1b2 - a2b1)

if data.dimS == 2
    data.UTimesDel2U_u =  data.v(2:end-1,2:end-1).*data.wdel2 - ...
                          data.w(2:end-1,2:end-1).*data.vdel2;

    data.UTimesDel2U_v =  data.w(2:end-1,2:end-1).*data.udel2 - ...
                          data.u(2:end-1,2:end-1).*data.wdel2;

    data.UTimesDel2U_w =  data.u(2:end-1,2:end-1).*data.vdel2 - ...
                          data.v(2:end-1,2:end-1).*data.udel2;

elseif data.dimS == 1

    data.UTimesDel2U_w =  data.u(2:end-1,2:end-1).*data.vdel2 - ...
                          data.v(2:end-1,2:end-1).*data.udel2;   
                      
%     data.UTimesDel2U_w = -data.UTimesDel2U_w;                
end