function [data, E , Diff, output]=GradientflowHarmonic(data, pars)
%-------------------------------------------------------------------------
% fixed step size algorithm
%
% Reference: 
%   Goldfarb, Donald and Wen, Zaiwen and Yin, Wotao
%   A Curvilinear Search Method for the p-Harmonic Flow on Sphere
%
% Author: Zaiwen Wen, Wotao Yin
%   Version 1.0 .... 2007/11
%-------------------------------------------------------------------------

% new trial point: data.u, data.v, data.w
%   intermediate point: data.ut, data.vt, data.wt

%% Size information
% [m,n]=size(data.u);
% if any([m,n]~=size(datav))  error('u and v have different sizes.'); end;


data = CheckUserData( data );

if ~isfield(pars, 'CheckOptimal')
    pars.CheckOptimal = 1;
end

if ~isfield(pars, 'GradEPS')
    pars.GradEPS = 1e-3;
end

if ~isfield(pars, 'maxiter')
    pars.maxiter = 5000;
end

E = zeros(1, pars.maxiter+1);
Diff = zeros(1,pars.maxiter+1);


%% Initial energy and error
% 
dt = data.dt;
data.u = data.u0;
data.v = data.v0;
if data.dimS == 2
    data.w = data.w0;
end

% compute derivative information
data = feval(pars.DiffCommon, data);

E(1) = feval(pars.EnergyFun, data);
% Diff(1) = feval(pars.DistanceUV, data);

if pars.CheckOptimal == 1
   output.optimal = 0; 
end

%% Print iteration header if debug == 1
if (pars.debug == 1)
    fid = 1;
    fprintf(fid, '----------- Vese_Osher Method ----------- \n');
    fprintf(fid, '%4s \t %10s \t %10s \n', 'Iter', 'dt', 'E(i)');
	fprintf(fid, '%4d \t %e \t %e	\n', 1, 0, E(1));
    %OUTPUT
end


%% Evolution
for ind = 2:(pars.maxiter+1)
 
    
    % compute the trial point Ut
    data = feval(pars.UpdateUScheme, data, dt);
    
    % copy the trial point Ut to U
    data = feval(pars.CopyUtToU, data);
    
    % compute derivative information
    data = feval(pars.DiffCommon, data);

    E(ind) = feval(pars.EnergyFun, data);
%     Diff(ind) = feval(pars.DistanceUV, data);


    % compute the gradient at current point
    data = feval(pars.EnergyGrad, data);
    energy_deriv = feval(pars.Energy_Deriv, 0, data);
    output.GradNorm = sqrt(abs( energy_deriv ));

    if pars.CheckOptimal == 1

        % if satisfy termination rule
%         if output.GradNorm <= pars.GradEPS *( 1 + E(ind-1) )
        if output.GradNorm <= pars.GradEPS
            output.Total_NFE = ind;
            output.TotalIter = ind;
            output.Fval = E(ind);
            output.optimal = 1;
            %                 output.Energy_Deriv = energy_deriv;
            return;
        end
    end

    % output information
    if (pars.debug == 1)
      fprintf(fid, '%4d \t %e \t %e \t %e\n', ind, dt, E(ind), output.GradNorm);
     %OUTPUT
    end
    

        
end

output.optimal = 0;
output.Total_NFE = pars.maxiter+1;
output.Fval = E(pars.maxiter+1);
output.TotalIter = pars.maxiter;
% output.Energy_Deriv = energy_deriv;
% fprintf('Deriv: %f \n', output.Energy_Deriv);
