function [data, E, Diff, dt_hist, output]= Harmonic_ls_GBB(data, pars)

%% Size information
% [m,n]=size(u);
% if any([m,n]~=size(v))  error('u and v have different sizes.'); end;

data = CheckUserData( data );


if ~isfield(pars, 'CheckOptimal')
    pars.CheckOptimal = 0;
end

if ~isfield(pars, 'GradEPS')
    pars.GradEPS = 1e-3;
end

if ~isfield(pars, 'sigma1')
    pars.sigma1 = 0.1;
end

if ~isfield(pars, 'sigma2')
    pars.sigma2 = 0.5;
end

if ~isfield(pars, 'M')
    pars.M = 5;
end

if ~isfield(pars, 'gamma')
    pars.gamma = 1e-4;
end

if ~isfield(pars, 'STPEPS')
    pars.STPEPS = 1e-10;
end

% pars.sigma1     = 0.1;
% pars.sigma2     = 0.5;
% pars.M          = 10;
% pars.gamma      = 1e-2;
% pars.STPEPS     = 1e-10;

% iteration history
E = zeros(1,(pars.maxiter+1));
Diff = zeros(1,(pars.maxiter+1));
dt_hist = zeros(1,pars.maxiter + 1);


% copy initial solution to the working space
data.u = data.u0;
data.v = data.v0;
if data.dimS == 2
    data.w = data.w0;
end

% compute finite difference information
data = feval(pars.DiffCommon, data);

% compute objective function value
E(1) = feval(pars.EnergyFun, data);
% Diff(1) = feval(pars.DistanceUV, data);
dt_hist(1) = 0;


% compute the gradient at current point
data = feval(pars.EnergyGrad, data);


output.Total_NFE = 0;
if pars.CheckOptimal == 1
    output.optimal = 0;
end


alpha = 1;
dt = 1e-2;

%% Print iteration header if debug == 1
if (pars.debug == 1)
    fid = 1;
    fprintf(fid, '----------- Global BB Method with Line search ----------- \n');
    fprintf(fid, '%4s \t %10s \t %10s \t %5s \t %9s \t %7s \n', 'Iter', 'dt', 'E(i)', 'Exit', 'funcCount', 'ls-Iter');
    fprintf(fid, '%4d \t %e \t %e \t %5d \t %5d	\t %6d	\n', 1, 0, E(1), 0, 0, 0);
    %OUTPUT
end


%% Evolution
for ind = 2 : (pars.maxiter+1)


    % begin line search

    % copy U , GradU, Div to temporary storage, this is because of the
    % data structure we use.  We need the directional derivaitve information at
    % the new trial point.
    %    d (E(U(t))) = grad( E(U(t)))' U'(t)
    % We copy "U , GradU, Div" to "U1 , GradU, Div1"
    % We copy "data" to "datals"
    % Then work on datals, but datals.U1 , GradU1, Div1 are information
    % relate to U, not to U(t)
    %
    % Finally, we copy datals to data to get U_{k+1}
    %

    data = feval(pars.CopyUInfoToTmp, data);
    energy_deriv = feval(pars.Energy_Deriv, 0, data);
    output.GradNorm = sqrt(abs( energy_deriv ));
    
    if pars.CheckOptimal == 1
        % if satisfy termination rule
        if output.GradNorm <= pars.GradEPS *( 1 + E(ind-1) )
%         if output.GradNorm <= pars.GradEPS 
            output.TotalIter = ind-1;
            output.Fval = energyt;
            output.optimal = 1;
            %                 output.Energy_Deriv = energy_deriv;
            return;
        end
    end


    % scale step size
    if alpha <= pars.STPEPS || alpha >= 1/pars.STPEPS

        if output.GradNorm > 1
            delta = 1;
        elseif output.GradNorm >= 1e-5
            delta = 1/output.GradNorm;
        else
            delta = 1e5;
        end
        alpha = delta;
    end
    dt = 1/alpha;


    output_ls.iter = 1;    output_ls.nfe = 0;

    energy0 = max( E ( ind- min(ind-1, pars.M): ind-1) );

    %       call line search, reverse communication
    while 1

        %% now, generate the new trial point
        % compute the trial point Ut
        datals = feval(pars.UpdateUScheme, data, dt);

        % copy the trial point Ut to U
        datals = feval(pars.CopyUtToU, datals);

        %% compute function value and gradient
        % compute error respect to the optimal solution
        datals = feval(pars.DiffCommon, datals);

        energyt = feval(pars.EnergyFun, datals);
        output_ls.nfe = output_ls.nfe + 1;

        if energyt <=  energy0 - pars.gamma*dt* (output.GradNorm.^2)

            output_ls.exitflag = 1;
            workls.msg = 'CONVERGENCE';
            break;
        end

        dt = ((pars.sigma1+pars.sigma2)/2 ) *dt;

        output_ls.iter = output_ls.iter + 1;

%         fprintf('dt: %5.4e \t f0: %5.4e \t f: %5.4e\n', dt, energy0 - pars.gamma*dt* (output.GradNorm.^2), energyt);
    end


    data = datals;
    output.Total_NFE = output.Total_NFE + output_ls.nfe;
    E(ind) = energyt;

    % compute the gradient at current point
    data = feval(pars.EnergyGrad, data);

    % update alpha
    gy = sum(sum(data.Gradu1.* (data.Gradu -data.Gradu1)  ...
        + data.Gradv1.* (data.Gradv -data.Gradv1) ));

    if data.dimS == 2
        gy = gy +  sum(sum(data.Gradw1.* (data.Gradw -data.Gradw1)));
    end

    alpha = -gy / ( dt*(output.GradNorm.^2));




    % compute error respect to the optimal solution

%     Diff(ind) = feval(pars.DistanceUV, data);
    dt_hist(ind) = dt;

    if (pars.debug == 1)
        fprintf(fid, '%4d \t %e \t %e \t %5d \t %5d	\t %6d	\t %s \n', ind,...
            dt, E(ind), output_ls.exitflag, output_ls.nfe, output_ls.iter, workls.msg);
        %OUTPUT
    end


end

%u = u_best;     v = v_best;
output.optimal = 0;
output.Fval = E(pars.maxiter);
output.TotalIter = pars.maxiter;

% output.Energy_Deriv = energy_deriv;
% fprintf('Deriv: %f \n', output.Energy_Deriv);
