function [u0,v0, uorg, vorg, h] = Prob1_S1p2_Dirichlet(noiselevel)

n = 22;
h=1/(n-1);

% h=1/51;

[x1,x2]=meshgrid(0:h:1);

rand('state', 0);

%% Original flows
uorg=(x1-0.5)./realsqrt((x1-0.5).*(x1-0.5)+(x2-0.5).*(x2-0.5));
vorg=(x2-0.5)./realsqrt((x1-0.5).*(x1-0.5)+(x2-0.5).*(x2-0.5));
showquiver(uorg,vorg,1);

%% Generate noisy flows

% u0=uorg+0.6*(1+x1.*x1-x2.*x2)- noiselevel*rand;
% v0=vorg+0.6*(x1-2*x2)+ noiselevel*rand;


u0=uorg+ .6*(1+x1.*x1-x2.*x2)-noiselevel*rand(n);
v0=vorg+ .6*(x1-2*x2)+noiselevel*rand(n);



tmp=realsqrt(u0.*u0+v0.*v0);
u0=u0./tmp; v0=v0./tmp; clear tmp;

%% Incorporate boundary condition
u0(1,:)=uorg(1,:);
u0(end,:)=uorg(end,:);
u0(:,1)=uorg(:,1);
u0(:,end)=uorg(:,end);

v0(1,:)=vorg(1,:);
v0(end,:)=vorg(end,:);
v0(:,1)=vorg(:,1);
v0(:,end)=vorg(:,end);

showquiver(u0,v0,1);
