
function [u0,v0, uorg, vorg, h] = Prob2_S1p1_Dirichlet(noiselevel)

h=1/21;

%  h=1/51;

[x1,x2]=meshgrid(0:h:1);
[m,n] = size(x1);

rand('state', 0);
randn('state', 0);

% %% Original flows
% uorg = zeros(m,n); vorg = zeros(m,n);
% m_mdl_pt = floor(m/2); n_mdl_pt = floor(n/2);
% % upper left part
% vorg(1:m_mdl_pt,1:n_mdl_pt) = 1;
% % upper right part
% uorg(1:m_mdl_pt,(n_mdl_pt+1):n) = 1;
% vorg(1:m_mdl_pt,(n_mdl_pt+1):n) = 2;
% % lower left part
% uorg((m_mdl_pt+1):m,1:n_mdl_pt) = 1;
% vorg((m_mdl_pt+1):m,1:n_mdl_pt) = 1;
% % lower right part
% uorg((m_mdl_pt+1):m,(n_mdl_pt+1):n) = -1;
% vorg((m_mdl_pt+1):m,(n_mdl_pt+1):n) = 1;


%% Original flows
uorg = zeros(m,n); vorg = zeros(m,n);
m_mdl_pt = floor(m/2); n_mdl_pt = floor(n/2);
% upper left part
vorg(1:m_mdl_pt,1:n_mdl_pt) = 1;
% upper right part
uorg(1:m_mdl_pt,(n_mdl_pt+1):n) = -1;
vorg(1:m_mdl_pt,(n_mdl_pt+1):n) = 1;
% lower left part
uorg((m_mdl_pt+1):m,1:n_mdl_pt) = 1;
vorg((m_mdl_pt+1):m,1:n_mdl_pt) = 1;
% lower right part
uorg((m_mdl_pt+1):m,(n_mdl_pt+1):n) = 2;
vorg((m_mdl_pt+1):m,(n_mdl_pt+1):n) = -1;


tmp=realsqrt(uorg.*uorg+vorg.*vorg);
uorg=uorg./tmp; vorg=vorg./tmp;

showquiver(uorg,vorg,1);

%% Generate noisy flows
u0=uorg; v0=vorg;

% randomize 20% points
clear tmp; tmp = (rand([m,n])< noiselevel );
tmp_nnz = nnz(tmp);

u0(tmp)=randn(tmp_nnz,1);
v0(tmp)=randn(tmp_nnz,1);
clear tmp;tmp=realsqrt(u0.*u0+v0.*v0);
u0=u0./tmp; v0=v0./tmp; clear tmp;

%% Incorporate boundary condition
u0(1,:)=uorg(1,:);
u0(end,:)=uorg(end,:);
u0(:,1)=uorg(:,1);
u0(:,end)=uorg(:,end);

v0(1,:)=vorg(1,:);
v0(end,:)=vorg(end,:);
v0(:,1)=vorg(:,1);
v0(:,end)=vorg(:,end);


% neumann boundary condition
% u0([1 end], 2:end-1) = u0([2 end-1],2:end-1);      u0(2:end-1, [1 end]) = u0(2:end-1, [2 end-1]);
% v0([1 end],2:end-1) = v0([2 end-1],2:end-1);      v0(2:end-1, [1 end]) = v0(2:end-1, [2 end-1]);

% u0([2 end-1],2:end-1) = u0([1 end], 2:end-1);      u0([2 end-1],2:end-1) = u0([1 end], 2:end-1);
% v0([2 end-1],2:end-1) = v0([1 end], 2:end-1);      v0([2 end-1],2:end-1) = v0([1 end], 2:end-1);

    
showquiver(u0,v0,1);
