

# =================================================
# Harmonic p-Flow
# (u,v,w) , S^2, p = 2
#
# Engery representation in \theta
# Int (  | (u grad v - v grad u)/ (u^2 + v^2 + w^2) |^2 
#			 + | (u grad w - w grad u)/ (u^2 + v^2 + w^2) |^2
#		   + | (v grad w - w grad v)/ (u^2 + v^2 + w^2) |^2 )^(p/2) 
#
# input:
#         (u , v, w)
# =================================================


# -------------------------------------------------
# Define problem's parameters

  
# Dimension of problem  
  param m ;
  param n ;
  
  

 
# -------------------------------------------------
# Define problem's variable

  var u {1..m, 1..n};
  var v {1..m, 1..n};
  var w {1..m, 1..n};
  
  param u0 {1..m, 1..n};
  param v0 {1..m, 1..n};
  param w0 {1..m, 1..n};
    


  

# --------------------------------------
# Objective
# --------------------------------------

minimize F:  sum{i in 2..m, j in 2..n}
	( ( ( 0.5*( u[i,j] + u[i-1,j] ) * ( v[i,j] - v[i-1,j] ) 	- 0.5*( v[i,j] + v[i-1,j] ) * ( u[i,j] - u[i-1,j] ) ) / 
 				(  0.25*( u[i,j] + u[i-1,j] )^2 + 0.25*( v[i,j] + v[i-1,j] )^2 + 0.25*( w[i,j] + w[i-1,j] )^2 ) )^2
 + ( ( 0.5*( u[i,j] + u[i,j-1] ) * ( v[i,j] - v[i,j-1] )- 0.5*( v[i,j] + v[i,j-1] ) * ( u[i,j] - u[i,j-1] ) ) / 
 				(  0.25*( u[i,j] + u[i,j-1] )^2 + 0.25*( v[i,j] + v[i,j-1] )^2 + 0.25*( w[i,j] + w[i,j-1] )^2 ) )^2 
 + ( ( 0.5*( u[i,j] + u[i-1,j] ) * ( w[i,j] - w[i-1,j] ) 	- 0.5*( w[i,j] + w[i-1,j] ) * ( u[i,j] - u[i-1,j] ) ) / 
 				(  0.25*( u[i,j] + u[i-1,j] )^2 + 0.25*( v[i,j] + v[i-1,j] )^2 + 0.25*( w[i,j] + w[i-1,j] )^2 ) )^2
 + ( ( 0.5*( u[i,j] + u[i,j-1] ) * ( w[i,j] - w[i,j-1] )- 0.5*( w[i,j] + w[i,j-1] ) * ( u[i,j] - u[i,j-1] ) ) / 
 				(  0.25*( u[i,j] + u[i,j-1] )^2 + 0.25*( v[i,j] + v[i,j-1] )^2 + 0.25*( w[i,j] + w[i,j-1] )^2 ) )^2 
 + ( ( 0.5*( v[i,j] + v[i-1,j] ) * ( w[i,j] - w[i-1,j] ) 	- 0.5*( w[i,j] + w[i-1,j] ) * ( v[i,j] - v[i-1,j] ) ) / 
 				(  0.25*( u[i,j] + u[i-1,j] )^2 + 0.25*( v[i,j] + v[i-1,j] )^2 + 0.25*( w[i,j] + w[i-1,j] )^2 ) )^2
 + ( ( 0.5*( v[i,j] + v[i,j-1] ) * ( w[i,j] - w[i,j-1] )- 0.5*( w[i,j] + w[i,j-1] ) * ( v[i,j] - v[i,j-1] ) ) / 
 				(  0.25*( u[i,j] + u[i,j-1] )^2 + 0.25*( v[i,j] + v[i,j-1] )^2 + 0.25*( w[i,j] + w[i,j-1] )^2 ) )^2 
);
 
 
# --------------------------------------
# Constraints
# --------------------------------------


# unit sphere constraints
#subject to sphere {i in 2..m-1, j in 2 .. n-1} :
#	 u[i,j]^2 + v[i,j]^2 + w[i,j]^2 = 1 ;

# boundary condition

subject to conu1x {i in 1..m} :
	 u[i,1] = u0[i,1] ;
subject to conunx {i in 1..m} :
	 u[i,n] = u0[i,n] ;
subject to conu1y {j in 2..n-1} :
	 u[1,j] = u0[1,j] ;
subject to conuny {j in 2..n-1} :
	 u[m,j] = u0[m,j] ;

subject to conv1x {i in 1..m} :
	 v[i,1] = v0[i,1] ;
subject to convxn {i in 1..m} :
	 v[i,n] = v0[i,n] ;
subject to conv1y {j in 2..n-1} :
	 v[1,j] = v0[1,j] ;
subject to convny {j in 2..n-1} :
	 v[m,j] = v0[m,j] ;

subject to conw1x {i in 1..m} :
	 w[i,1] = w0[i,1] ;
subject to conwxn {i in 1..m} :
	 w[i,n] = w0[i,n] ;
subject to conw1y {j in 2..n-1} :
	 w[1,j] = w0[1,j] ;
subject to conwny {j in 2..n-1} :
	 w[m,j] = w0[m,j] ;


