/*----------------------------------------------------------
 function  = ...
ComputeEnergyGradDiscrete(t, data.u1, data.v1, data.w1)
----------------------------------------------------------*/

#include "mex.h"

/* The gateway routine */
void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{
  /* Input */  
  double *uvec, *vvec, *wvec;
  double *Diva, *Divb, *Divc;
  double t;
  int mrows,ncols;
  
  /* Output */  
  double *Gradu, *Gradv, *Gradw;
  
  double u, v, w, a, b, c;
  int di, dj, idi;
  
  
  /*  Check for proper number of arguments. */
  /* NOTE: You do not need an else statement when using 
     mexErrMsgTxt within an if statement. It will never 
     get to the else statement if mexErrMsgTxt is executed. 
     (mexErrMsgTxt breaks you out of the MEX-file.) 
  */ 
  if (nrhs != 6) 
    mexErrMsgTxt("Six inputs required.");
  if (nlhs != 3) 
    mexErrMsgTxt("Three output required.");
  
  
  /* Create a pointer to the input matrix u, v, w. */
  uvec = mxGetPr(prhs[0]);
  vvec = mxGetPr(prhs[1]);
  wvec = mxGetPr(prhs[2]);
 

  /* Create a pointer to the input matrix Diva, Divb, Divc. */
  Diva = mxGetPr(prhs[3]);
  Divb = mxGetPr(prhs[4]);
  Divc = mxGetPr(prhs[5]);
	
	  
  /* Get the dimensions of the matrix input u. */
  mrows = mxGetM(prhs[0]);
  ncols = mxGetN(prhs[0]);
  
 
  /* Set the output pointer to the output matrix ut, vt, wt */
  plhs[0] = mxCreateDoubleMatrix(mrows,ncols, mxREAL);
  plhs[1] = mxCreateDoubleMatrix(mrows,ncols, mxREAL);
  plhs[2] = mxCreateDoubleMatrix(mrows,ncols, mxREAL);

  Gradu  = mxGetPr(plhs[0]);
  Gradv  = mxGetPr(plhs[1]);
  Gradw  = mxGetPr(plhs[2]);

  
  for( di = 0; di<mrows; di++ )
  {
    for( dj = 0; dj<ncols; dj++ )
    {
        /* x direction */
        idi = dj*mrows + di;   
        u = uvec[idi];		a = Divc[idi];
	v = vvec[idi];		b = Divb[idi];
	w = wvec[idi];		c = Diva[idi];
	   
	Gradu[idi] =  v*c - w*b;
	Gradv[idi] = -u*c + w*a;
	Gradw[idi] =  u*b - v*a;
	
    }
  }


  
}
