/*----------------------------------------------------------
 function energy_deriv = ...
ComputeEnergyDirectionDerivS2(t, data.u1, data.v1, data.w1, ...
                                 data.Diva, data.Divb, data.Divc);
----------------------------------------------------------*/

#include "mex.h"

/* The gateway routine */
void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{
  /* Input */  
  double *uvec, *vvec, *wvec;
  double *Diva, *Divb, *Divc;
  double *Gradu, *Gradv, *Gradw;
  double t;
  int mrows,ncols;
  
  /* Output */  
  double *Deriv;

  double u, v, w, a, b, c;
  double at, bt, ct, atsq, btsq, ctsq, abctsq;
  double dut, dvt, dwt;
  int di, dj, idi;
  
  
  /*  Check for proper number of arguments. */
  /* NOTE: You do not need an else statement when using 
     mexErrMsgTxt within an if statement. It will never 
     get to the else statement if mexErrMsgTxt is executed. 
     (mexErrMsgTxt breaks you out of the MEX-file.) 
  */ 
  if (nrhs != 10) 
    mexErrMsgTxt("Ten inputs required.");
  if (nlhs != 1) 
    mexErrMsgTxt("One output required.");
  
  /* Check to make sure the first input argument is a scalar. */
  if (!mxIsDouble(prhs[0]) || mxIsComplex(prhs[0]) ||
      mxGetN(prhs[0])*mxGetM(prhs[0]) != 1) {
    mexErrMsgTxt("Input x must be a scalar.");
  }
  
  /* Get the scalar input t */
  t    = mxGetScalar(prhs[0]);
  
  /* Create a pointer to the input matrix u, v, w. */
  uvec = mxGetPr(prhs[1]);
  vvec = mxGetPr(prhs[2]);
  wvec = mxGetPr(prhs[3]);
 

  /* Create a pointer to the input matrix Diva, Divb, Divc. */
  Diva = mxGetPr(prhs[4]);
  Divb = mxGetPr(prhs[5]);
  Divc = mxGetPr(prhs[6]);
	
  Gradu = mxGetPr(prhs[7]);
  Gradv = mxGetPr(prhs[8]);
  Gradw = mxGetPr(prhs[9])
	  ;
  /* Get the dimensions of the matrix input u. */
  mrows = mxGetM(prhs[1]);
  ncols = mxGetN(prhs[1]);
  
  /* Set the output pointer to the output scalar */
  plhs[0] = mxCreateDoubleMatrix(1,1, mxREAL);
  
  /* Create a C pointer to a copy of the output scalar */
  Deriv = mxGetPr(plhs[0]);
  
  Deriv[0] = 0.0; 
	  
  for( di = 0; di<mrows; di++ )
  {
    for( dj = 0; dj<ncols; dj++ )
    {
        /* x direction */
        idi = dj*mrows + di;   
        u = uvec[idi];		a = Divc[idi];
	v = vvec[idi];		b = Divb[idi];
	w = wvec[idi];		c = Diva[idi];
	at = t*a;		atsq = at*at;
	bt = t*b;		btsq = bt*bt;
	ct = t*c;		ctsq = ct*ct;
	abctsq = (4+atsq+btsq+ctsq);
	abctsq *= abctsq;
       
        dut = (c*(4*v*ctsq - 16*ct*u + 16*w*at - 16*v  + 
		4*v*atsq + 4*v*btsq -4* w*bt*ct) -4*b*(-4*w
		- 4*at*v + w*atsq + 4*u*bt + w*btsq) ) /abctsq;

	dvt =  (-4*c*(4*ct*v + ctsq*u - ct*at*w - 4*bt*w +
		u*atsq + u*btsq - 4*u) - 4*a*(4*w - btsq*w
		- 4*bt*u + 4*at*v - w*atsq) ) /abctsq;

	dwt =  (4*a*(4*v - 4*w*at + 4*ct*u - v*atsq + u*at*bt
		- v*btsq - v*ctsq)  + 4*b*(-4*u - 4*w*bt +
		4*ct*v + u*btsq + u*ctsq) )/abctsq;
	
	Deriv[0] += Gradu[idi]*dut + Gradv[idi]*dvt +
			Gradw[idi]*dwt;
    }
  }


  
}

