/*----------------------------------------------------------
 function energy_deriv = ...
ComputeUpdateSchemeDiscreteS2(t, data.u1, data.v1, data.w1, ...
                                 data.Diva, data.Divb, data.Divc);
----------------------------------------------------------*/

#include "mex.h"

/* The gateway routine */
void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{
  /* Input */  
  double *uvec, *vvec, *wvec;
  double *Diva, *Divb, *Divc;
  double t;
  int mrows,ncols;
  
  /* Output */  
  double *ut, *vt, *wt;

  double u, v, w, a, b, c;
  double at, bt, ct, atsq, btsq, ctsq, abctsq;
  int di, dj, idi;
  
  
  /*  Check for proper number of arguments. */
  /* NOTE: You do not need an else statement when using 
     mexErrMsgTxt within an if statement. It will never 
     get to the else statement if mexErrMsgTxt is executed. 
     (mexErrMsgTxt breaks you out of the MEX-file.) 
  */ 
  if (nrhs != 7) 
    mexErrMsgTxt("Seven inputs required.");
  if (nlhs != 3) 
    mexErrMsgTxt("Three output required.");
  
  /* Check to make sure the first input argument is a scalar. */
  if (!mxIsDouble(prhs[0]) || mxIsComplex(prhs[0]) ||
      mxGetN(prhs[0])*mxGetM(prhs[0]) != 1) {
    mexErrMsgTxt("Input x must be a scalar.");
  }
  
  /* Get the scalar input t */
  t    = mxGetScalar(prhs[0]);
  
  /* Create a pointer to the input matrix u, v, w. */
  uvec = mxGetPr(prhs[1]);
  vvec = mxGetPr(prhs[2]);
  wvec = mxGetPr(prhs[3]);
 

  /* Create a pointer to the input matrix Diva, Divb, Divc. */
  Diva = mxGetPr(prhs[4]);
  Divb = mxGetPr(prhs[5]);
  Divc = mxGetPr(prhs[6]);
	
	  
  /* Get the dimensions of the matrix input u. */
  mrows = mxGetM(prhs[1]);
  ncols = mxGetN(prhs[1]);
  
 
  /* Set the output pointer to the output matrix ut, vt, wt */
  plhs[0] = mxCreateDoubleMatrix(mrows,ncols, mxREAL);
  plhs[1] = mxCreateDoubleMatrix(mrows,ncols, mxREAL);
  plhs[2] = mxCreateDoubleMatrix(mrows,ncols, mxREAL);

  ut  = mxGetPr(plhs[0]);
  vt  = mxGetPr(plhs[1]);
  wt  = mxGetPr(plhs[2]);

  
  for( di = 0; di<mrows; di++ )
  {
    for( dj = 0; dj<ncols; dj++ )
    {
        /* x direction */
        idi = dj*mrows + di;   
        u = uvec[idi];		a = Divc[idi];
	v = vvec[idi];		b = Divb[idi];
	w = wvec[idi];		c = Diva[idi];
	at = t*a;		atsq = at*at;
	bt = t*b;		btsq = bt*bt;
	ct = t*c;		ctsq = ct*ct;
	abctsq = (4+atsq+btsq+ctsq);
       
	ut[idi] = (-4*ct*v + 4*bt*w + 4*u +u*atsq + 2*at*bt*v
		- btsq*u - u*ctsq + 2*at*ct*w) /abctsq;
	
        vt[idi] = (-atsq*v + 2*at*bt*u - 4*at*w + v*btsq
		- ctsq*v + 2*bt*ct*w + 4*ct*u + 4*v) /abctsq; 
	
	wt[idi] = ( w*ctsq - w*atsq - w*btsq + 4*at*v -
		4*bt*u + 4*w + 2*bt*ct*v + 2*at*ct*u) /abctsq; 
	    
	
    }
  }


  
}
