function data = DataPepperDenoising (name, noiselev, probsize)


close all;

% noiselev = 0.2;

randn('state', 0);

% peppers = imread('peppers.png');
% peppers = imread('autumn.tif'); %image(peppers);
% peppers = imread('fabric.png'); %image(peppers);
% peppers = imread('pillsetc.png'); %image(peppers);


%--------------------------------------------
% make sure that the data structure is uint8;

if strcmp(name, 'pepper') == 1
    peppers = imread('onion.png');
    if strcmp(probsize, 's') == 1
        idx = 40:135;    idy = 110:198;
        idx = 20:135;    idy = 90:198;  
        peppers = peppers(idx, idy, :);
    end
    
elseif strcmp(name, 'clown') == 1
    
    s = load('clown'); peppers = ind2rgb(s.X,s.map); 
    peppers = uint8(round(peppers*255));
    if strcmp(probsize, 's') == 1
        idx = 1:150;    idy = 1:150;
        peppers = peppers(idx, idy, :);
    end
    
elseif strcmp(name, 'fabric') == 1
    peppers = imread('fabric.png');
    idx = 1:300;    idy = 1:300;
    peppers = peppers(idx, idy, :);
    if strcmp(probsize, 's') == 1
        idx = 1:150;    idy = 1:150;
        peppers = peppers(idx, idy, :);
    end   
    
end

%--------------------------------------------




image(peppers);

peppers = double(peppers);
data.u_exact = peppers(:,:,1);
data.v_exact = peppers(:,:,2);
data.w_exact = peppers(:,:,3);

% To avoid the case that the brightness equals to zero
tol = 1e-6; 
idx = (abs(data.u_exact) < tol) & (abs(data.v_exact) < tol) &(abs(data.w_exact) < tol);
data.u_exact(idx) = 1;

% data.u_exact = peppers(idx, idy,1);
% data.v_exact = peppers(idx, idy,2);
% data.w_exact = peppers(idx, idy,3);
% 
% tol = 1e-6; 
% data.u_exact(abs(data.u_exact) < tol) = tol;
% data.v_exact(abs(data.v_exact) < tol) = tol;
% data.v_exact(abs(data.v_exact) < tol) = tol;

[m,n] = size(data.u_exact);

data.m = m;
data.n = n;
data.dimS = 2;
data.p = 2;
data.hx = 1;
data.hy = 1;

% normalize the solution
data.Bright = sqrt(data.u_exact.^2 + data.v_exact.^2 + data.w_exact.^2);


data.u_exact = data.u_exact./data.Bright;
data.v_exact = data.v_exact./data.Bright;
data.w_exact = data.w_exact./data.Bright;

% PlotRGB(data.u_exact, data.v_exact, data.w_exact, data.Bright);
% 


% create noise
noiseu = randn(m,n);
noisev = randn(m,n);
noisew = randn(m,n);



% noiseu = noiseu./noiseNorm;
% noisev = noisev./noiseNorm;
% noisew = noisew./noiseNorm;

% add noise to image
data.u0 = data.u_exact + noiselev*noiseu;
data.v0 = data.v_exact + noiselev*noisev;
data.w0 = data.w_exact + noiselev*noisew;

uvwsq0 = sqrt(data.u0.^2 + data.v0.^2 + data.w0.^2);
data.u0 = data.u0./uvwsq0;
data.v0 = data.v0./uvwsq0;
data.w0 = data.w0./uvwsq0;

% noiseNorm = sqrt(noiselev*sum( sum( noiseu.^2 + noisev.^2 + noisew.^2 )));
noiseNorm = sqrt(noiselev*sum( sum( (data.u0 - data.u_exact).^2 ...
                                    +(data.v0 - data.v_exact).^2 ...
                                    +(data.w0 - data.w_exact).^2 )));

fprintf('\nm: %d, n: %d, noise in data: %4.3e\n', m, n, noiseNorm);

data.noiseNorm = noiseNorm;

% PlotRGB(data.u0, data.v0, data.w0, data.Bright);
% data.u0(1:10,1:10)

% Neumann boundary condition
      
data.boundary = 'Neumann';

data.u0(1,:)    = data.u_exact(2,:);            data.u0(2,:)        = data.u_exact(2,:);
data.u0(end,:)  = data.u_exact(end-1,:);        data.u0(end-1,:)    = data.u_exact(end-1,:);
data.u0(:,1)    = data.u_exact(:,2);            data.u0(:,2)        = data.u_exact(:,2);
data.u0(:,end)  = data.u_exact(:,end-1);        data.u0(:,end-1)    = data.u_exact(:,end-1);

data.v0(1,:)    = data.v_exact(2,:);            data.v0(2,:)        = data.v_exact(2,:);
data.v0(end,:)  = data.v_exact(end-1,:);        data.v0(end-1,:)    = data.v_exact(end-1,:);
data.v0(:,1)    = data.v_exact(:,2);            data.v0(:,2)        = data.v_exact(:,2);
data.v0(:,end)  = data.v_exact(:,end-1);        data.v0(:,end-1)    = data.v_exact(:,end-1);

data.w0(1,:)    = data.w_exact(2,:);            data.w0(2,:)        = data.w_exact(2,:);
data.w0(end,:)  = data.w_exact(end-1,:);        data.w0(end-1,:)    = data.w_exact(end-1,:);
data.w0(:,1)    = data.w_exact(:,2);            data.w0(:,2)        = data.w_exact(:,2);
data.w0(:,end)  = data.w_exact(:,end-1);        data.w0(:,end-1)    = data.w_exact(:,end-1);


% %-----------------------------------------------------------------
% % Dirichlet boundary condition
% data.boundary = 'Dirichlet';
% 
% data.u0(1,:)    = data.u_exact(1,:);
% data.u0(end,:)  = data.u_exact(end,:);
% data.u0(:,1)    = data.u_exact(:,1);
% data.u0(:,end)  = data.u_exact(:,end);
% 
% data.v0(1,:)    = data.v_exact(1,:);
% data.v0(end,:)  = data.v_exact(end,:);
% data.v0(:,1)    = data.v_exact(:,1);
% data.v0(:,end)  = data.v_exact(:,end);
% 
% data.w0(1,:)    = data.w_exact(1,:);
% data.w0(end,:)  = data.w_exact(end,:);
% data.w0(:,1)    = data.w_exact(:,1);
% data.w0(:,end)  = data.w_exact(:,end);
% %-----------------------------------------------------------------

PlotRGB(data.u0, data.v0, data.w0, data.Bright);
