function data = DataProb3_S2_Dirichlet(h, p, b)

% h=sqrt(2)/2^4;
[x1,x2]=meshgrid(-1:h:1);

n = size(x1,1);
data.m = n;
data.n = n;
data.dimS = 2;
data.hx = h;
data.hy = h;
data.p = p;





%% Original flows
xsqroot = realsqrt(x1.^2+x2.^2);
data.u_exact = x1./xsqroot;
data.v_exact = x2./xsqroot;
data.w_exact = zeros(size(x1));
showquiver(data.u_exact, data.v_exact,1);

%% Generate noisy flows

% b = 3*pi/2;
% b = pi/2;

data.u0 = zeros(size(x1));
data.v0 = zeros(size(x1));
data.w0 = zeros(size(x1));

data.u0(xsqroot <=1) = data.u_exact(xsqroot<=1) .* sin( b*xsqroot(xsqroot<=1).^2 );
data.u0(xsqroot >1) = data.u_exact(xsqroot>1) .* sin( b );

data.v0(xsqroot <=1) = data.v_exact(xsqroot<=1) .* sin( b*xsqroot(xsqroot<=1).^2 );
data.v0(xsqroot >1) = data.v_exact(xsqroot>1) .* sin( b );

data.w0(xsqroot <=1) =  cos( b*xsqroot(xsqroot<=1).^2 );
data.w0(xsqroot >1) =   cos( b );

%-----------------------------------------------------------------
% Dirichlet boundary condition
data.boundary = 'Dirichlet';

data.u0(1,:)    = data.u_exact(1,:);
data.u0(end,:)  = data.u_exact(end,:);
data.u0(:,1)    = data.u_exact(:,1);
data.u0(:,end)  = data.u_exact(:,end);

data.v0(1,:)    = data.v_exact(1,:);
data.v0(end,:)  = data.v_exact(end,:);
data.v0(:,1)    = data.v_exact(:,1);
data.v0(:,end)  = data.v_exact(:,end);

data.w0(1,:)    = data.w_exact(1,:);
data.w0(end,:)  = data.w_exact(end,:);
data.w0(:,1)    = data.w_exact(:,1);
data.w0(:,end)  = data.w_exact(:,end);

%-----------------------------------------------------------------
% data.u0 = data.u_exact;
% data.v0 = data.v_exact;
% data.w0 = data.w_exact;


%-----------------------------------------------------------------
% Neumann boundary condition
      
% data.boundary = 'Neumann';

% data.u0(1,:)    = data.u_exact(2,:);            data.u0(2,:)        = data.u_exact(2,:);
% data.u0(end,:)  = data.u_exact(end-1,:);        data.u0(end-1,:)    = data.u_exact(end-1,:);
% data.u0(:,1)    = data.u_exact(:,2);            data.u0(:,2)        = data.u_exact(:,2);
% data.u0(:,end)  = data.u_exact(:,end-1);        data.u0(:,end-1)    = data.u_exact(:,end-1);
% 
% data.v0(1,:)    = data.v_exact(2,:);            data.v0(2,:)        = data.v_exact(2,:);
% data.v0(end,:)  = data.v_exact(end-1,:);        data.v0(end-1,:)    = data.v_exact(end-1,:);
% data.v0(:,1)    = data.v_exact(:,2);            data.v0(:,2)        = data.v_exact(:,2);
% data.v0(:,end)  = data.v_exact(:,end-1);        data.v0(:,end-1)    = data.v_exact(:,end-1);
% 
% data.w0(1,:)    = data.w_exact(2,:);            data.w0(2,:)        = data.w_exact(2,:);
% data.w0(end,:)  = data.w_exact(end-1,:);        data.w0(end-1,:)    = data.w_exact(end-1,:);
% data.w0(:,1)    = data.w_exact(:,2);            data.w0(:,2)        = data.w_exact(:,2);
% data.w0(:,end)  = data.w_exact(:,end-1);        data.w0(:,end-1)    = data.w_exact(:,end-1);

%-----------------------------------------------------------------

showquiver(data.u0, data.v0,1);

% data.u_exact
% data.u0


