function data = DataProb4_S2_Dirichlet(h, p)

% h=sqrt(2)/2^4;
[x1,x2]=meshgrid(-1:h:1);

n = size(x1,1);
data.m = n;
data.n = n;
data.dimS = 2;
data.h = h;
data.p = p;

data.boundary = 'Dirichlet';


rand('state', 0);

%% Original flows
xsqroot = realsqrt(x1.^2+x2.^2);
data.u_exact = ones(size(x1));
data.v_exact = zeros(size(x1));
data.w_exact = zeros(size(x1));
showquiver(data.u_exact, data.v_exact,1);

%% Generate noisy flows

% b = 3*pi/2;
% b = pi/2;

data.u0 = zeros(size(x1));
data.v0 = zeros(size(x1));
data.w0 = zeros(size(x1));

data.u0(xsqroot <=0.5) = 0;
data.u0(xsqroot >0.5) = 1;

data.v0(xsqroot <=0.5) = 1;
data.v0(xsqroot >0.5) = 0;

data.w0 = data.w0 + rand(size(x1));

NormU = realsqrt(data.u0.^2 + data.v0.^2 + data.w0.^2);
data.u0 = data.u0./NormU;
data.v0 = data.v0./NormU;
data.w0 = data.w0./NormU;

data.u0(1,:)    = data.u_exact(1,:);
data.u0(end,:)  = data.u_exact(end,:);
data.u0(:,1)    = data.u_exact(:,1);
data.u0(:,end)  = data.u_exact(:,end);

data.v0(1,:)    = data.v_exact(1,:);
data.v0(end,:)  = data.v_exact(end,:);
data.v0(:,1)    = data.v_exact(:,1);
data.v0(:,end)  = data.v_exact(:,end);

data.w0(1,:)    = data.w_exact(1,:);
data.w0(end,:)  = data.w_exact(end,:);
data.w0(:,1)    = data.w_exact(:,1);
data.w0(:,end)  = data.w_exact(:,end);

showquiver(data.u0, data.v0,1);



