function energy_deriv = EnergyDirectionDerivHarmonicDiscrete(t, data)


[m, n] = size(data.u);


if t == 0

    energy_deriv = -sum( sum( data.Gradu.*data.Gradu + data.Gradv.*data.Gradv ));
    if data.dimS == 2
        energy_deriv = energy_deriv-sum( sum( data.Gradw.*data.Gradw ));
    end

else


    idx = 2:m-1;   idy = 2:n-1;

    % for convience notation


    if data.dimS == 1
        u = data.u1(idx, idy);
        v = data.v1(idx, idy);
        c  = data.Diva1;
        ct = t*data.Diva1;
        ctsq = ct.^2;
        abctsq = (4 + ctsq).^2;

        %   dut(idx, idy) = -4.*c*(4.*v-1.*v*t^2*c^2+4.*t*c*u)/(4.+t^2*c^2)^2
        %   dvt(idx, idy) = -4.*c*(-4.*u+4.*t*c*v+t^2*c^2*u)/(4.+t^2*c^2)^2
        dut = c.*(-16*v + 4*v.*ctsq - 16*ct.*u)./ abctsq;
        dvt = c.*(16*u - 4*u.*ctsq - 16*ct.*v)./ abctsq;


        energy_deriv = sum( sum( data.Gradu.* dut)) ...
            + sum( sum( data.Gradv.* dvt));

    elseif data.dimS == 2

        % Call c-mex file
        energy_deriv = ComputeEnergyDirectionDerivS2 ...
            (t, data.u1(idx, idy), data.v1(idx, idy), data.w1(idx, idy), ...
            data.Diva1, data.Divb1, data.Divc1, ...
            data.Gradu, data.Gradv, data.Gradw);

        %         w = data.w1(idx, idy);

        %         a  = data.Divc1;
        %         at = t*data.Divc1;
        %         atsq = at.^2;
        %
        %         b  = data.Divb1;
        %         bt = t*data.Divb1;
        %         btsq = bt.^2;
        %
        %         c  = data.Diva1;
        %         ct = t*data.Diva1;
        %         ctsq = ct.^2;
        %
        %         abctsq = (4 + atsq + btsq + ctsq).^2;
        %
        %         %     dut = -4.*(-1.*v*c^3*t^2+4.*t*c^2*u-4.*t*c*a*w+4.*v*c-4.*b*w-4.*t*b*a*v-1.*v*c*t^2*a^2-1.*v*c*t^2*b^2+b*w*t^2*a^2+b*w*t^2*c^2+4.*t*b^2*u+b^3*w*t^2)/(4.+t^2*a^2+t^2*b^2+t^2*c^2)^2
        %         %     dvt = -4.*(4.*t*c^2*v+t^2*c^3*u+4.*w*a-1.*t^2*c^2*a*w-1.*t^2*a*b^2*w-4.*c*t*b*w+c*u*t^2*a^2+c*t^2*b^2*u-4.*t*a*b*u-4.*c*u+4.*t*a^2*v-1.*w*a^3*t^2)/(4.+t^2*a^2+t^2*b^2+t^2*c^2)^2
        %         %     dwt = 4.*(4.*v*a-4.*b*u-4.*w*t*a^2-4.*w*t*b^2+4.*t*b*c*v+4.*t*a*c*u+b^3*u*t^2-1.*v*a^3*t^2+b*u*t^2*a^2+b*u*t^2*c^2-1.*v*a*t^2*b^2-1.*v*a*t^2*c^2)/(4.+t^2*a^2+t^2*b^2+t^2*c^2)^2
        %
        %
        %         %     (-4.*c*(-1.*v*c^2*t^2+4.*t*c*u-4.*t*a*w+4.*v-1.*v*t^2*a^2-1.*v*t^2*b^2+b*w*t^2*c)
        %         %     -4*b*(-4.*w-4.*t*a*v+w*t^2*a^2+4.*t*b*u+b^2*w*t^2)) ./abctsq;
        %
        %         dut = (c.*(4.*v.*ctsq - 16.*ct.*u + 16.*w.*at - 16.*v  + 4.*v.*atsq + 4.*v.*btsq -4* w.*bt.*ct) ...
        %             -4*b.*(-4.*w - 4.*at.*v + w.*atsq + 4.*u.*bt + w.*btsq) ) ./abctsq;
        %
        %         %     -4.*c.*(4.*t*c*v+t^2*c^2*u-1.*t^2*c*a*w-4.*t*b*w+u*t^2*a^2+t^2*b^2*u-4.*u)
        %         %     -4* a*(4.*w-1.*t^2*b^2*w-4.*t*b*u+4.*t*a*v-1.*w*a^2*t^2)
        %
        %         dvt =  (-4.*c.*(4.*ct.*v + ctsq.*u - 1.*ct.*at.*w - 4.*bt.*w + u.*atsq + u.*btsq - 4.*u) ...
        %             - 4*a.*(4.*w - btsq.*w - 4.*bt.*u + 4.*at.*v - w.*atsq) ) ./abctsq;
        %
        %         %         4.*a*(4.*v-4.*w*t*a+4.*t*c*u-1.*v*a^2*t^2+b*u*t^2*a-1.*v*t^2*b^2-1.*v*t^2*c^2)
        %         %         4*b*(-4.*u-4.*w*t*b+4.*t*c*v+b^2*u*t^2+u*t^2*c^2)
        %
        %
        %         dwt =  (4.*a.*(4.*v - 4.*w.*at + 4.*ct.*u - v.*atsq + u.*at.*bt - v.*btsq - v.*ctsq) ...
        %             + 4*b.*(-4.*u - 4.*w.*bt + 4.*ct.*v + u.*btsq + u.*ctsq) )./abctsq;
        %
        %
        %         energy_deriv = sum( sum( data.Gradu.* dut)) ...
        %             + sum( sum( data.Gradv.* dvt)) ...
        %             + sum( sum( data.Gradw.* dwt));

    end

    %     norm( data.Gradu(2:end-1,2:end-1) + dut(2:end-1,2:end-1) , 'fro')
    %     norm( data.Gradv(2:end-1,2:end-1) + dvt(2:end-1,2:end-1) , 'fro')
    %     norm( data.Gradw(2:end-1,2:end-1) + dwt(2:end-1,2:end-1) , 'fro')

end


