function data = EnergyGradientHarmonicDiscrete(data)

% Gradient of the discrete function: EnergyHarmonicDiscrete
% stored in: data.Gradu, Gradv, Gradw 
%
[m,n] = size(data.u);
idx = 2:m-1;    idy = 2:n-1;

if data.dimS == 1
    data.Gradu = data.v(idx,idy).*data.Diva;
    data.Gradv = -data.u(idx,idy).*data.Diva;
elseif data.dimS == 2
%     data.Gradu = data.v(idx,idy).*data.Diva - data.w(idx,idy).*data.Divb;
%     data.Gradv = -data.u(idx,idy).*data.Diva + data.w(idx,idy).*data.Divc;
%     data.Gradw = data.u(idx,idy).*data.Divb - data.v(idx,idy).*data.Divc;

 [data.Gradu, data.Gradv, data.Gradw] = ...
 ComputEnergeGradDiscreteS2( data.u(idx,idy),   data.v(idx,idy), data.w(idx,idy), ...
                              data.Diva, data.Divb, data.Divc);
end


