function GenerateDataAmpl(pars)

clc;
close all;
%------------------------------------------------
% parameter for examples
pars.p = 2; 
pars.p = 1;

if pars.p == 1

    Prob2_S1p1_Dirichlet
elseif pars.p == 2

    Prob1_S1p2_Dirichlet
end



Prob = {'Prob2_S1p1_Dirichlet', 'Prob1_S1p2_Dirichlet'};


% Prepare data filename
OutPutFile = strcat('./ampl/',Prob{pars.p});
    
OutPutFileDat = strcat(OutPutFile, '.dat');
    
fid  = fopen(OutPutFileDat, 'w');   


[m,n]=size(u0);

% set parameters m,n
fprintf(fid, '\n \n # data file for Harmonic Flow \n\n');
fprintf(fid, 'param m := %f ; \n\n', m);
fprintf(fid, 'param n := %d ;\n\n', n);


% set initial data u
fprintf(fid, '\nvar u:  \n \t');
fprintf(fid, '\t \t  %d   ', [1:m]);
fprintf(fid, ' := \n');

for indi = 1:m
    fprintf(fid, '\t  %d \t', indi);
    for indj = 1:n
        
        fprintf(fid, '%f  \t', u0(indi,indj));
    
    end
    fprintf(fid, '\n');
end
fprintf(fid,'; \n \n');

% set initial data v
fprintf(fid, '\nvar v:  \n \t');
fprintf(fid, '\t \t   %d   ', [1:n]);
fprintf(fid, ' := \n');

for indi = 1:m
    fprintf(fid, '\t  %d \t', indi);
    for indj = 1:n
        
        fprintf(fid, '%f  \t', v0(indi,indj));
    
    end
    fprintf(fid, '\n');
end
fprintf(fid,';');

fclose(fid);

