function GenerateDataAmplS2(pars)

clc;
close all;
%------------------------------------------------
% parameter for examples
% pars.p = 2; 
% pars.p = 1;

u0 = pars.u0;
v0 = pars.v0;
w0 = pars.w0;

Prob = 'DataProb3_S2_Dirichlet';


% Prepare data filename
OutPutFile = strcat('./ampl/',Prob, 'p', num2str(pars.p));
    
OutPutFileDat = strcat(OutPutFile, '.dat');
    
fid  = fopen(OutPutFileDat, 'w');   


[m,n]=size(u0);

% set parameters m,n
fprintf(fid, '\n \n # data file for Harmonic Flow \n\n');
fprintf(fid, 'param m := %d ; \n\n', m);
fprintf(fid, 'param n := %d ;\n\n', n);

%--------------------------------------------------------------------------
% set param
% set initial data u
fprintf(fid, '\nparam u0:  \n \t');
fprintf(fid, '\t \t  %d   ', [1:m]);
fprintf(fid, ' := \n');

for indi = 1:m
    fprintf(fid, '\t  %d \t', indi);
    for indj = 1:n
        
        fprintf(fid, '%f  \t', u0(indi,indj));
    
    end
    fprintf(fid, '\n');
end
fprintf(fid,'; \n \n');

% set initial data v
fprintf(fid, '\nparam v0:  \n \t');
fprintf(fid, '\t \t   %d   ', [1:n]);
fprintf(fid, ' := \n');

for indi = 1:m
    fprintf(fid, '\t  %d \t', indi);
    for indj = 1:n
        
        fprintf(fid, '%f  \t', v0(indi,indj));
    
    end
    fprintf(fid, '\n');
end
fprintf(fid,';');

% set initial data v
fprintf(fid, '\nparam w0:  \n \t');
fprintf(fid, '\t \t   %d   ', [1:n]);
fprintf(fid, ' := \n');

for indi = 1:m
    fprintf(fid, '\t  %d \t', indi);
    for indj = 1:n
        
        fprintf(fid, '%f  \t', w0(indi,indj));
    
    end
    fprintf(fid, '\n');
end
fprintf(fid,';');

% end param
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
% set initial data

% set initial data u
fprintf(fid, '\nvar u:  \n \t');
fprintf(fid, '\t \t  %d   ', [1:m]);
fprintf(fid, ' := \n');

for indi = 1:m
    fprintf(fid, '\t  %d \t', indi);
    for indj = 1:n
        
        fprintf(fid, '%f  \t', u0(indi,indj));
    
    end
    fprintf(fid, '\n');
end
fprintf(fid,'; \n \n');

% set initial data v
fprintf(fid, '\nvar v:  \n \t');
fprintf(fid, '\t \t   %d   ', [1:n]);
fprintf(fid, ' := \n');

for indi = 1:m
    fprintf(fid, '\t  %d \t', indi);
    for indj = 1:n
        
        fprintf(fid, '%f  \t', v0(indi,indj));
    
    end
    fprintf(fid, '\n');
end
fprintf(fid,';');

% set initial data v
fprintf(fid, '\nvar w:  \n \t');
fprintf(fid, '\t \t   %d   ', [1:n]);
fprintf(fid, ' := \n');

for indi = 1:m
    fprintf(fid, '\t  %d \t', indi);
    for indj = 1:n
        
        fprintf(fid, '%f  \t', w0(indi,indj));
    
    end
    fprintf(fid, '\n');
end
fprintf(fid,';');

fclose(fid);

%--------------------------------------------------------------------------