function [data, E, Diff, dt_hist, output]= Harmonic_ls(data, pars)
%-------------------------------------------------------------------------
% Line search algorithm for p-harmonic flow
%
% Reference: 
%   Goldfarb, Donald and Wen, Zaiwen and Yin, Wotao
%   A Curvilinear Search Method for the p-Harmonic Flow on Sphere
%
% Author: Zaiwen Wen, Wotao Yin
%   Version 1.0 .... 2007/11
%-------------------------------------------------------------------------


%% Size information
% [m,n]=size(u);
% if any([m,n]~=size(v))  error('u and v have different sizes.'); end;

data = CheckUserData( data );


if ~isfield(pars, 'CheckOptimal')
    pars.CheckOptimal = 1;
end

if ~isfield(pars, 'GradEPS')
    pars.GradEPS = 1e-3;
end

if ~isfield(pars, 'maxiter')
    pars.maxiter = 5000;
end

% iteration history 
E = zeros(1,(pars.maxiter+1));
Diff = zeros(1,(pars.maxiter+1));
dt_hist = zeros(1,pars.maxiter + 1);


% copy initial solution to the working space
data.u = data.u0;
data.v = data.v0;
if data.dimS == 2
    data.w = data.w0;
end

% compute finite difference information
data = feval(pars.DiffCommon, data);

% compute objective function value
E(1) = feval(pars.EnergyFun, data);
% Diff(1) = feval(pars.DistanceUV, data);
dt_hist(1) = 0;

    
% compute the gradient at current point
data = feval(pars.EnergyGrad, data);
    
output.Total_NFE = 1;
if pars.CheckOptimal == 1
   output.optimal = 0; 
end

% parameters for line search
parsls.maxiter = 10;

parsls.ftol = 1e-4;
parsls.gtol = 0.9;
dt = 1e-2;


%% Print iteration header if debug == 1
if (pars.debug == 1)
    fid = 1;
    fprintf(fid, '----------- Projected Gradient Method with Line search: %s ----------- \n', pars.linesearch );
    fprintf(fid, '%4s \t %10s \t %10s \t %5s \t %9s \t %7s \n', 'Iter', 'dt', 'E(i)', 'Exit', 'funcCount', 'ls-Iter');
    fprintf(fid, '%4d \t %e \t %e \t %5d \t %5d	\t %6d	\n', 1, 0, E(1), 0, 0, 0);
    %OUTPUT
end


%% Evolution
for ind = 2 : (pars.maxiter+1)


    % begin line search
%     clear workls;

    % must set "work.task = 1"
    workls.task =1;
  

    
    % copy U , GradU, Div to temporary storage, this is because of the
    % data structure we use.  We need the directional derivaitve information at
    % the new trial point. 
    %    d (E(U(t))) = grad( E(U(t)))' U'(t)
    % We copy "U , GradU, Div" to "U1 , GradU, Div1"
    % We copy "data" to "datals"
    % Then work on datals, but datals.U1 , GradU1, Div1 are information
    % relate to U, not to U(t)
    %
    % Finally, we copy datals to data to get U_{k+1}
    % 
    
    data = feval(pars.CopyUInfoToTmp, data);    
    % objective function value, copy from previous computation
    energyt = E(ind-1);
    energy_deriv = feval(pars.Energy_Deriv, 0, data);
    output.GradNorm = sqrt(abs( energy_deriv ));


    if pars.CheckOptimal == 1
        % if satisfy termination rule
%         if output.GradNorm <= pars.GradEPS *( 1 + E(ind-1) )
        if output.GradNorm <= pars.GradEPS
            output.TotalIter = ind-1;
            output.Fval = energyt;
            output.optimal = 1;
            %                 output.Energy_Deriv = energy_deriv;
            return;
        end
    end 
    
    output_ls.iter = 0;    output_ls.nfe = 0;

    %       call line search, reverse communication
    while 1

        [dt, energyt, energy_deriv, parsls, workls] = ls_csrch(dt, energyt, energy_deriv , parsls , workls);

        % Evaluate the function and the gradient at stp
        if (workls.task == 2)


            %% now, generate the new trial point
            % compute the trial point Ut
            datals = feval(pars.UpdateUScheme, data, dt);

            % copy the trial point Ut to U
            datals = feval(pars.CopyUtToU, datals);

            %% compute function value and gradient
            % compute error respect to the optimal solution
            datals = feval(pars.DiffCommon, datals);

            energyt = feval(pars.EnergyFun, datals);

            % compute gradient at current point, must have called DiffCommon before
            datals = feval(pars.EnergyGrad, datals);

            energy_deriv = feval(pars.Energy_Deriv, dt, datals);

            output_ls.iter = output_ls.iter + 1;      output_ls.nfe = output_ls.nfe + 1;

        else  % exit
            break
        end
    end


    data = datals;
    output.Total_NFE = output.Total_NFE + output_ls.nfe;
    output_ls.exitflag = workls.task;

    E(ind) = energyt;
  
   
    % compute error respect to the optimal solution

%     Diff(ind) = feval(pars.DistanceUV, data);
    dt_hist(ind) = dt;

    if (pars.debug == 1)
        fprintf(fid, '%4d \t %e \t %e \t %5d \t %5d	\t %6d	\t %s \n', ind,...
            dt, E(ind), output_ls.exitflag, output_ls.nfe, output_ls.iter, workls.msg);
        %OUTPUT
    end


end

%u = u_best;     v = v_best;
output.optimal = 0;
output.Fval = E(pars.maxiter+1);
output.TotalIter = pars.maxiter;

% output.Energy_Deriv = energy_deriv;
% fprintf('Deriv: %f \n', output.Energy_Deriv);
