% README file for GradflowSphere

% ----------------------------------------------------------------
% BUILD THE EXECUTABLE AND MEX FILES.
% ----------------------------------------------------------------
% 
% To build the executable mex-files from the c-files,
% the most direct method is to run the MATLAB script file
% ** installmex.m ** in the directory
% 
% GradflowSphere
% 
% That is, do the following at the MATLAB command window:
% 
% >> installmex
% 
% It is important that you run the script file in the
% directory mentioned above.
% 

% ----------------------------------------------------------------
% Demo files:
%   * S1/S2 case: 
%       DriverHarmonicFlow.m
%
%   * Color image denoising: 
%       DriverHarmonicFlowColorImageDenoising.m
% ----------------------------------------------------------------

% ----------------------------------------------------------------
% Methods:
%   * Gradient flow method with fixed step size
%       GradientflowHarmonic.m
%
%   * Line search method with Armijo-Wolfe conditions
%       Harmonic_ls.m
%     --> Selecting a step size using Armijo-Wolfe condtion
%         ls_csrch.m, ls_dcstep.m
%
%   * Nonmonone line search methods:
%     - Barzilar-Borwein's method beginning with a few monotone line searchs     
%        Harmonic_ls_BB_mix.m
% ----------------------------------------------------------------

% ----------------------------------------------------------------
% Test Problems:
%   S1 case: DataProb1_S1p2_Dirichlet.m
%   S2 case: DataProb3_S2_Dirichlet.m
%
%   **************************************************************
%   The AMPL files, including the "mod" file, data file and their corresonding 
%   "nl" file, corresponding to the S2 case are in the subdirectory ampl
%   **************************************************************
%
%   Color image denoising: DataPepperDenoising.m
% ----------------------------------------------------------------

% ----------------------------------------------------------------
% individual functions
%   * update the value of the new iteration
%     UpdateUSchemeImplicit1Discrete.m
%     --> c-file for S2 case:
%       ComputeUpdateSchemeDiscreteS2.c
%
%   * Computing function value and gradient of the 
%     - preparing data structures
%       DiffCommonDiscrete.m 
%       --> c-file for S2 case
%           ComputeDiffCommonDiscreteS2.c 
%
%     - function value
%       EnergyHarmonicDiscrete.m
%   
%     - directional directive and gradient for line search  
%       EnergyDirectionDerivHarmonicDiscrete.m
%       EnergyGradientHarmonicDiscrete.m
%       --> c-file for S2 case:
%           ComputeEnergyDirectionDerivS2.c
%           ComputEnergeGradDiscreteS2.c 
%
%   * Utility functions
% 
%     - Copy data structure
%       CopyUInfoToTmpStorage.m
%       CopyUtToU.m
%
%-------------------------------------------------------------------------



%-------------------------------------------------------------------------
% Reference: 
%   Goldfarb, Donald and Wen, Zaiwen and Yin, Wotao
%   A Curvilinear Search Method for the p-Harmonic Flow on Sphere
%
% Author: Zaiwen Wen, Wotao Yin
%   Version 1.0 .... 2007/11
%-------------------------------------------------------------------------



