function data = UpdateUSchemeImplicit1Discrete(data, t)

% u is of order m*n
data.ut = data.u;    
data.vt = data.v;
idx = 2:data.m-1;   idy = 2:data.n-1;

% for convience notation
u = data.u(idx, idy);
v = data.v(idx, idy);



if data.dimS == 1
    ct = t*data.Diva;
    ctsq = ct.^2;
    
%     u(idx, idy) = (4*u-u*t^2*c^2-4.*t*c*v)./(4+t^2*c^2)
%     v(idx, idy) = (4.*v+4.*t*c*u-1.*t^2*c^2*v)/(4.+t^2*c^2)    
    data.ut(idx, idy) = (4*u - u.*ctsq - 4*ct.*v)./(4 + ctsq);
    data.vt(idx, idy) = (4*v + 4.*ct.*u- ctsq.*v)./(4 + ctsq);       
    
elseif data.dimS == 2
    data.wt = data.w;
    w = data.w(idx, idy);
    
     % Call c-mex file
    [data.ut(idx, idy), data.vt(idx, idy), data.wt(idx, idy)] = ...
        ComputeUpdateSchemeDiscreteS2 ...
        (t, u, v, w, data.Diva, data.Divb, data.Divc);

%     at = t*data.Divc;
%     atsq = at.^2;
%     
%     bt = t*data.Divb;
%     btsq = bt.^2;
% 
%     ct = t*data.Diva;
%     ctsq = ct.^2;
%     
%     abctsq = 4 + atsq + btsq + ctsq;
% 
% %     u = (-4.*t*c*v+4.*t*b*w+4.*u+u*t^2*a^2+2.*t^2*b*a*v-1.*t^2*b^2*u-1.*u*t^2*c^2+2.*t^2*c*a*w)/(4.+t^2*a^2+t^2*b^2+t^2*c^2)
% %     v = (-1.*t^2*a^2*v+2.*t^2*a*b*u-4.*t*a*w+v*t^2*b^2-1.*t^2*c^2*v+2.*c*t^2*b*w+4.*t*c*u+4.*v)/(4.+t^2*a^2+t^2*b^2+t^2*c^2)
% %     w = (w*t^2*c^2-1.*w*t^2*a^2-1.*w*t^2*b^2+4.*t*a*v-4.*t*b*u+4.*w+2.*t^2*b*c*v+2.*t^2*a*c*u)/(4.+t^2*a^2+t^2*b^2+t^2*c^2)
%     
%     
%     data.ut(idx, idy) = (-4.*ct.*v + 4.*bt.*w + 4.*u +u.*atsq + 2.*at.*bt.*v - btsq.*u - u.*ctsq + 2.*at.*ct.*w) ./abctsq;
%     data.vt(idx, idy) = (-atsq.*v + 2.*at.*bt.*u - 4.*at.*w + v.*btsq - ctsq.*v + 2.*bt.*ct.*w + 4.*ct.*u + 4.*v) ./abctsq; 
%     data.wt(idx, idy) = ( w.*ctsq - w.*atsq - w.*btsq + 4.*at.*v - 4.*bt.*u + 4.*w + 2.*bt.*ct.*v + 2.*at.*ct.*u) ./abctsq; 
   
end




if strcmp(data.boundary, 'Neumann')
    
    data.ut(1,:)    = data.ut(2,:);
    data.ut(end,:)  = data.ut(end-1,:);
    data.ut(:,1)    = data.ut(:,2);
    data.ut(:,end)  = data.ut(:,end-1);
    
    data.vt(1,:)    = data.vt(2,:);
    data.vt(end,:)  = data.vt(end-1,:);
    data.vt(:,1)    = data.vt(:,2);
    data.vt(:,end)  = data.vt(:,end-1);    
    
    if data.dimS == 2
        data.wt(1,:)    = data.wt(2,:);
        data.wt(end,:)  = data.wt(end-1,:);
        data.wt(:,1)    = data.wt(:,2);
        data.wt(:,end)  = data.wt(:,end-1);
    end
    
end