% define symbolic objects
syms a b c u v w t
% define the matrix version of the cross product
J = [0 -c b; c 0 -a; -b a 0];

% define intermediate matrix
Wminus =  eye(3) - 0.5*t*J;
Wplus  =  eye(3) + 0.5*t*J;

% solve the system of linear equations
Ut = simplify( inv(Wminus)* Wplus * [u;v; w])

Utu = Ut - [ u; v ; w];
simplify(Utu.'*Utu)

% compute the derivative of Ut with respect t
dUt = simplify( diff(Ut,'t') )

ddUt = simplify( diff(dUt,'t') )

simple( ddUt - (ddUt.'*Ut)* Ut )

% % check the determinant of the matrix Wminus
% det(Wminus)
% % simplify(eig(Wminus))
% 
% % check the 2-norm of the matrix Lemma 2.11
% hatW = inv(Wminus)* Wplus - eye(3);
% simplify(eig( hatW.'*hatW) )
% 
% tidleW = 0.5* inv(Wminus)*J*(eye(3) + inv(Wminus)* Wplus) - J;
% simplify(eig( tidleW.'*tidleW) )
% 
% G = cross( [u;v;w], [a; b; c]);
% normG = sqrt(G.'*G);
% 
% % simplify(normG)
% 
% UtG = cos(t*normG)* [u;v;w] + sin(t*normG)*G/normG;
% 
% simplify(UtG)
% 
% simplify(Ut - UtG)
% 
% 
% % 
% % syms d t u c
% % 
% % r = cos(d*t)*u + sin(d*t)*c/d;
% % dr = diff(r, 't')
% % ddr = diff(dr, 't')
% % 
% % simplify((ddr.'*r) *r - ddr )